

***********************************************
*      Episode Splitting Examples
*       Josef Brderl, March 2011
***********************************************

version 11
cd "K:\Vorlesung EHA\Stata Beispiele\"    //working directory


use "Example Episplit.dta", clear
list ID T FAIL XT , sepby(ID)
* We have single episode-data
* T gives duration (say in months)
* FAIL is the failure indicator (1=failure, 0=censoring)
* XT gives the time-point when the time-varying covariate X changes from 0 to 1

stset T, failure(FAIL==1) id(ID)
list ID T FAIL XT _t0 _t _d _st, sepby(ID)
* Stset built the "response triple" (_t0, _t, _d) that is used in any
* following EHA procedure. _st==1 means that the record is used in an analysis

stsplit T0, every(1)
list ID T0 T FAIL XT _t0 _t _d _st, sepby(ID)
* Note that you do not need to stset the data anew, everything is
* done correctly by stsplit. In particular the response triple is as it should be
* T is split up
* T0 notes the beginning of the split
* FAIL is set ., the original value is copied on the last split
* Everything else is copied

gen X = T0 >= XT     // constructing the time-varying covariate
list ID T0 T FAIL XT X _t0 _t _d _st, sepby(ID)


* Constant rate model
streg X, dist(exp)   // continuous time EHA
logit _d X ,or       // discrete time EHA

* Piecewise-constant rate model
gen P3to4 = (T>=3 & T<=4)
gen P5to = (T>=5)
streg P3to4 P5to X , dist(exp)     // continuous time EHA
* logit _d P3to4 P5to  X ,or       // discrete time EHA (does not work, some cells have all 0 or 1)



****************************************************
* "Person-Period" splitting blows up your file.
* If you want to "let the air out":
****************************************************
drop T0          //one has to drop the variable that stsplit created
drop P3to4 P5to  //and the period dummies
stjoin           //works only, if you did not recode FAIL. Otherwise option censored(#)
list ID T FAIL XT X _t0 _t _d _st, sepby(ID)
streg X, dist(exp)



****************************************************
* If you intend to use only continuous time models
* then you could split without air from the beginning
* B. Jann (2004) Stata Journal
****************************************************

use "Example Episplit.dta", clear
list ID T FAIL XT , sepby(ID)

stset T, failure(FAIL==1) id(ID)
list ID T FAIL XT _t0 _t _d _st, sepby(ID)

stsplit X, after(XT) at(0)
replace X = X+1
list ID T FAIL XT X _t0 _t _d _st, sepby(ID)

streg X, dist(exp)


**************************************************
*     Episode Splitting with Left Truncation
**************************************************

use "Example Episplit.dta", clear

generate T0 = 0
replace  T0 = 2 in 3    //observation 3 entered at 2
list ID T0 T FAIL XT , sepby(ID)

stset T, failure(FAIL==1) id(ID) time0(T0)
list ID T0 T FAIL XT _t0 _t _d _st, sepby(ID)

stsplit TS, every(1)
list ID TS T FAIL XT _t0 _t _d _st, sepby(ID)

gen X = TS >= XT     // constructing the time-varying covariate
list ID TS T FAIL XT X _t0 _t _d _st, sepby(ID)

streg X, dist(exp)   // continuous time EHA


